/**********************************************************************************************
* Device      : AD18F08
* Author      : TANWENBO
* Version     : V0.0.1
* Date        : 2023.5.11
* Description : 演示配置TMR1的脉宽检测模式并且将所得到的数据通过串口打印出来
***********************************************************************************************/

#include "AD18F08.h"
#include <stdio.h>
#include "common.h"
#include "AD18F08_Com.h"


/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG口不能做普通IO用）
* _LVREN_OFF         :  LVR使能位
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL				:  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _ADCSP_ON			:  ADC采集速度选择位
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见头文件；
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L    & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    & _ADCSP_ON_4L                                                                                       );


unsigned long  TIMER1_T=0;
uint32_t period;
uint16_t ccpr_temp;
unsigned char start_flag=1;

void main (void)
{

	GPIO_Init();     //IO初始化
	usart_init();	//模拟串口初始化
    printf("AD18F08_test\r\n");

	 //Timer1_edge_io();  //IO脉宽测量函数模式0
	 Timer1_edge_io_mode1();//IO脉宽测量函数模式1
     //Timer1_edge_mode1();  //TMR2CLK 脉宽测量函数模式1
    //Timer1_edge();         //TMR2CLK 脉宽测量函数模式1

	IPEN = 1;	   	//允许高低优先级
	GIEH=1;
	GIEL=1;
	while(1)
     {
		if(start_flag==3)
		{
			start_flag=1;
			INT2IE=0;	//关闭中断
			GIEH=0;
			GIEL=0;
			ccpr_temp=(TMR1H<<8|TMR1L);
			period= ccpr_temp+(TIMER1_T*65536);	//us
			printf ("period=%lu us\r\n",period);
			TIMER1_T=0;
			GIEH=1;
			GIEL=1;
			INT2IF = 0;
			INT2IE=1;	//开中断
		}
     }
}

//高优先级中断服务函数
void interrupt ISR_h (void)
{
//进入中断后系统自动关闭中断
	unsigned char tmp_int;
	if(TMR1IF==1  &&  TMR1IE==1)
	{
		TMR1IF = 0;
		TMR1H=0X00;
		TMR1L=0X00;
	    TIMER1_T++;	//针对长脉宽——TIMER1溢出中断，但未发生边沿触发中断
	}
	tmp_int = PIR2;
	if((tmp_int&0X10)==0X10 && INT2IE == 1)
    {
		INT2IF = 0;
		start_flag++; //采集结束
		if (start_flag==2)
		{
			TMR1H=0X00;
			TMR1L=0X00;
			TIMER1_T=0;
		}
    }
}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{
//进入中断后系统自动关闭中断

}

